function JQuickFilterDialog(owner, parent, name, dataset, field, caption, rect)
{
	var self = this,
		_rendered = false,
		_disposed = false,
		_dragHandler = null;

	this.initialize(owner, parent, name, caption, null, rect, null, field, dataset);

	this.isForm   = true;
	this.methods  = (cmRender | cmLoad);

	this.local = null;
	this.confirm  = null;
	this.cancel   = null;
	this.cancelFilter = null;
	this.edit = null;

	this.owner.addImage("close-icon", "close.gif", "form");
	this.rect.normalize(this.owner.getDocument().body);
	this.owner.activeForm = this;

	this.render = render;
	this.load   = load;
	this.close  = close;
	this.isRendered = isRendered;
	this.dispose = dispose;

	function render(fs)
	{
		if (_rendered)
			return;

		var rectEdit = "10;25;250;21";
		var rectCancelFilter  = utils.format("%1;%2;%3;%4", self.rect.width - 240, self.rect.height - 60, 75, 24);
		var rectConfirm = utils.format("%1;%2;%3;%4", self.rect.width - 155, self.rect.height - 60, 60, 24);
		var rectCancel  = utils.format("%1;%2;%3;%4", self.rect.width -  85, self.rect.height - 60, 60, 24);

		if (self.local == null)
		{
			self.local = self.owner.registerObject("__" + self.name + "_local", new JDataset(self.owner, self.name, "__" + self.name + "_local", "", "", dfNone));
			self.local.addField(new JField("val", "", self.field.type, "", ffNone));
  			self.local.loadRecord("add", "", "val=%17", rsUnchanged, rfNone, true);

			var label = self.owner.registerObject(self.name + "_lab_1", new JLabel(self.owner, self.name, self.name + "_lab_1", null, null, self.field.caption, laNone, "10;8;200;21", null));

			var type = self.field.type;
			if (utils.inList(type, ftString, ftMemo, ftInteger, ftFloat))
			{
				self.edit = self.owner.registerObject(self.name + "_edit", new JEdit(self.owner, self.name, self.name + "_edit", self.local, "val", rectEdit, etSimple, null));
			}
			else
			if (utils.inList(type, ftDate, ftTime, ftDateTime))
			{
				self.edit = self.owner.registerObject(self.name + "_edit", new JCalendar(self.owner, self.name, self.name + "_edit", self.local, "val", rectEdit, null));
			}
			else
			if (type == ftEnum)
			{
				self.local.fields["val"].items = self.field.items;
				self.edit  = self.owner.registerObject(self.name + "_edit", new JEnumPicker(self.owner, self.name, self.name + "_edit", self.local, "val", rectEdit, null));
			}
			else
			if (type == ftSet)
			{
				self.local.fields["val"].items = self.field.items;
				self.edit  = self.owner.registerObject(self.name + "_edit", new JSetPicker(self.owner, self.name, self.name + "_edit", self.local, "val", rectEdit, null));
			}

			self.cancelFilter  = self.owner.registerObject(self.name + "_cancelFilter",  new JButton(self.owner, self.name, self.name + "_cancelFilter", self.owner.localize("capCancelFilter"), true, rectCancelFilter,  raCloseParent, null));
			self.confirm = self.owner.registerObject(self.name + "_confirm", new JButton(self.owner, self.name, self.name + "_confirm", self.owner.localize("capOK"),     true, rectConfirm, raCloseParent, null));
			self.cancel  = self.owner.registerObject(self.name + "_cancel",  new JButton(self.owner, self.name, self.name + "_cancel",  self.owner.localize("capCancel"), true, rectCancel,  raCloseParent, null));

			self.addControl(label);
			self.addControl(self.edit);
			self.addControl(self.confirm);
			self.addControl(self.cancel);
			self.addControl(self.cancelFilter);
		}


		fs.append( '<div class="dialogForm" id="' + self.name + '" style="' + self.rect + '">');
		fs.append('  <div id="' + self.name + '_title" class="form_titlebar">');
		fs.append('    <span id="' + self.name + '_caption" class="form_caption">' + self.caption + '</span>');
		fs.append('  </div>');

		fs.append(   '<div class="dialogForm_inlet" id="' + self.name + '_inlet" style="top: ' + (fmDragbarHeight + fmBorderWidth) + 'px; height: ' + (self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + (self.rect.width - 2 * fmBorderWidth) + 'px">');

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmRender, control.methods))
			{
				control.render(fs);
			}
		}, self);

		fs.append(   "</div>");
		fs.append( "</div>");

		_rendered = true;
	}

	function load()
	{
		self.owner.getDocument().body.appendChild(self.$$());

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		self.owner.splash(true);
		self.owner.setSplashInfo('');

		if (self.edit.set_focus)
			self.edit.set_focus();
		else
		if (self.$$('_edit') != null)
			self.$$('_edit').focus();

		if (typeof(DragHandler) != 'undefined')
			_dragHandler = new DragHandler(self.$$(), self.$$('_title'));
	}

	function close(e)
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		var element = utils.getEventElement(e);
		
		while (element.className != 'button')
		{
			element = element.parentNode;
		}

		self.$$().style.borderStyle = 'outset';
		if (element.id == self.name + '_confirm')
		{
			var query  = new Postback();
			query.set('afm', self.dataset.parent);
			query.set('ads', self.dataset.name);
			query.set('fld', self.field.name);
			query.set('val', escape(escape(self.local.get('val'))));
			query.set('rst', '1');

			self.owner.post(raQuickFilter, query);
		}
		else
		if (element.id == self.name + '_cancelFilter')
		{
			var query  = new Postback();
			query.set('afm', self.dataset.parent);
			query.set('ads', self.dataset.name);
			query.set('rst', '-1');

			self.owner.post(raQuickFilter, query);
		}

		self.owner.unregisterObject(self.name);
	}

	function isRendered()
	{
	  return _rendered;
	}

	function dispose()
	{
		if (_disposed)
			return;

		if (_dragHandler != null)
			_dragHandler.dispose();

		self.disposeChildren();
		self.local.dispose();
		self.local = null;

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JQuickFilterDialog.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();